
%STM32F103_GET_PLOT
  if(exist('skt')==0) skt=sktopen('192.168.1.4'); endif
  noplot=0;
  pkg load signal;
  n=2048;
  win=flattopwin(n);
  win=sqrt(2)*win/(sum(win));
  win=win*ones(1,2);
  SRATE_MAX=875000;
  tfz=exp(i*pi*108/180)/285;%exp(i*pi*113/180)/345;  % open circuit output impedance - measured by setting lod open and tfz=0;
  SRate=STM32F103_ADC_SETUP(skt,[1;0],6750000/8); % make 1st channel volts 2nd current
   ADC_Scale = [248.34 0; 0 24];
  Tvec=(1:2048)/SRate;

% Calibration initial match for rload only
  Vcal= 1*exp(-5*i*pi/180); % Compensate for phase angle into real load
  Ical=1;

  STM32F103_CC_SETUP_B3(skt);


    f=STM32F103_CC_GET(skt);
    bin=floor((((f/SRate)-floor(f/SRate))*2048)+1);
    if (bin>2048) bin=2048; endif
    dat=STM32F103_ADC_PLOT(skt,2048,-1)';
    md=ones(2048,1)*mean(dat);
    Vref_Scale=1.5/mean(mean(dat));
    data=(dat-md)*ADC_Scale*Vref_Scale;
    atten=abs(1/(1+i*f*2*pi*1000*11e-12)); % Compensate for rc input in STM32ADC
    df=fft(data.*win)/atten;
    df(:,2)=df(:,2)*Ical;
    df(:,1)=df(:,1)*Vcal;

   if (noplot==0)
     f1=figure(1);
     clf
     plot(Tvec,data');

    res=[sprintf("Freqency=%2.4f MHz",f/1e6)
    sprintf("Impedance=%4.3f Ohms  %4.1f Degrees",abs(df(bin,1)/df(bin,2)),(180/pi)*angle(df(bin,1)/df(bin,2)))
    sprintf("Power (Real)=%4.3f  (Imag)=%4.3f  W",real(df(bin,1)*df(bin,2)'),imag(df(bin,1)*df(bin,2)'))
    sprintf("Voltage = %4.3f Vrms",abs(df(bin,1)))
    sprintf("Current = %4.3f Irms",abs(df(bin,2)))];
    f1tit=title(res);


     grid on;
     f1c=get(f1,'children');
     axis([0 2048/SRate -150 150]);
     f1cc=get(f1c,'children');
     legend(['Volts';'Amps ']);

     xlabel(['Seconds      ' sprintf('Sample Rate = %f',SRate)]   );
     ylabel('Volts');
     f2=figure(2);

     clf
     hold off
     plot(20*log10(abs(df(2:2030,:))))
     axis([0 2048 -50 70]);
     grid on;
     ylabel('dB re 1 volt or 1 amp');
     xlabel('Frequency bin')
     f2c=get(f2,'children');
     f2cc=get(f2c,'children');
     t2=title(sprintf('Frequency = %fMHz',f/1e6));
     hold on
     f3=plot(bin,60,'*');
     legend(['Volts';'Amps ';'Freq ']);

  endif
  commandwindow
  loop=1;
  while (loop>0)
    f=STM32F103_CC_GET(skt);
    data=STM32F103_ADC_PLOT(skt,2048,-1)';
    data=(data-md);
    data=data*ADC_Scale*Vref_Scale;
    if (noplot==0)
%     figure(1);
%     plot(Tvec,data);
     set(f1cc(2),'ydata',data(:,1)');
     set(f1cc(1),'ydata',data(:,2)');

    res=[sprintf("Freqency=%2.4f MHz",f/1e6)
    sprintf("Impedance=%4.3f Ohms  %4.1f Degrees",abs(df(bin,1)/df(bin,2)),(180/pi)*angle(df(bin,1)/df(bin,2)))
    sprintf("Power (Real)=%4.3f  (Imag)=%4.3f  W",real(df(bin,1)*df(bin,2)'),imag(df(bin,1)*df(bin,2)'))
    sprintf("Voltage = %4.3f Vrms",abs(df(bin,1)))
    sprintf("Current = %4.3f Irms",abs(df(bin,2)))];
    set(f1tit,'string',res);
%     title(sprintf('Frequency = %fMHz',f/1e6));

    endif
    bin=floor(0.5+((f/SRate)-floor(f/SRate))*2048)+1;
%    data=sin(bin*2*pi*(1:2048)/2048)'*ones(1,2);
    df=fft(data.*win)/atten;
    df(:,1)=df(:,1)*Vcal;
    df(:,2)=df(:,2)*Ical;
    df(:,2)=df(:,2)-tfz*df(:,1);
    df(:,1)=df(:,1)*1 ;
    if ((bin>3)&&(bin<2046))
    [dbin,didx]=max(abs(df(bin-1:(bin+1))));
    bin=bin+didx-2;
    endif

    if (noplot==0)
%     figure(2)
     hold off
%     plot(20*log10(abs(df(2:1023,:))))
     set(f2cc(2),'ydata',20*log10(abs(df(2:2030,1)))');
     set(f2cc(1),'ydata',20*log10(abs(df(2:2030,2)))');
     set(t2,'string',sprintf('Frequency = %fMHz  Bin - %d',f/1e6,bin));

     hold on
     set(f3,'xdata',bin-1) ;
 %   plot(bin,10,'*');
  endif

   pause(0.2)
   if (min(size(kbhit(1)))>0) loop=0; endif
  endwhile

